/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.CustomButton;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.data.AssetInformation;

public class SelectButtonTool
extends SelectResourceTool {
    protected AdventureData adventureData;
    protected String type;
    protected String action;
    protected boolean removed;

    protected static AssetInformation[] createAssetInfoArray(String string, String string2) {
        AssetInformation[] assetInformationArray = new AssetInformation[]{new AssetInformation("", string + "#" + string2, true, 9, 0)};
        return assetInformationArray;
    }

    protected static Resources createResources(AdventureData adventureData, String string, String string2) {
        Resources resources = new Resources();
        boolean bl = false;
        for (int i = 0; i < adventureData.getButtons().size(); ++i) {
            CustomButton customButton = (CustomButton)adventureData.getButtons().get(i);
            if (!customButton.getType().equals(string2) || !customButton.getAction().equals(string)) continue;
            resources.addAsset(string + "#" + string2, customButton.getPath());
            bl = true;
            break;
        }
        if (!bl) {
            resources.addAsset(string + "#" + string2, null);
        }
        return resources;
    }

    public SelectButtonTool(AdventureData adventureData, String string, String string2) throws CloneNotSupportedException {
        super(SelectButtonTool.createResources(adventureData, string, string2), SelectButtonTool.createAssetInfoArray(string, string2), 230, 0);
        this.adventureData = adventureData;
        this.type = string2;
        this.action = string;
    }

    @Override
    public boolean undoTool() {
        boolean bl = super.undoTool();
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.adventureData.getButtons().size(); ++i) {
            if (!((CustomButton)this.adventureData.getButtons().get(i)).getType().equals(this.type) || !((CustomButton)this.adventureData.getButtons().get(i)).getAction().equals(this.action)) continue;
            if (this.removed) {
                this.adventureData.getButtons().remove(i);
                this.setButton(this.action, this.type, this.resources.getAssetPath(this.action + "#" + this.type));
                break;
            }
            ((CustomButton)this.adventureData.getButtons().get(i)).setPath(this.resources.getAssetPath(this.action + "#" + this.type));
            break;
        }
        this.controller.updatePanel();
        this.controller.dataModified();
        return true;
    }

    @Override
    public boolean redoTool() {
        boolean bl;
        if (this.removed) {
            this.adventureData.addButton(this.action, this.type, "");
        }
        if (!(bl = super.redoTool())) {
            return false;
        }
        for (int i = 0; i < this.adventureData.getButtons().size(); ++i) {
            if (!((CustomButton)this.adventureData.getButtons().get(i)).getType().equals(this.type) || !((CustomButton)this.adventureData.getButtons().get(i)).getAction().equals(this.action)) continue;
            ((CustomButton)this.adventureData.getButtons().get(i)).setPath(this.resources.getAssetPath(this.action + "#" + this.type));
        }
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean doTool() {
        int n;
        if (this.resources.getAssetPath(this.action + "#" + this.type) == null) {
            this.removed = false;
        } else {
            for (n = 0; n < this.adventureData.getButtons().size(); ++n) {
                CustomButton customButton = (CustomButton)this.adventureData.getButtons().get(n);
                if (!customButton.getAction().equals(this.action) || !customButton.getType().equals(this.type)) continue;
                this.adventureData.getButtons().remove(customButton);
                break;
            }
            this.removed = true;
        }
        n = super.doTool();
        if (n == 0) {
            return false;
        }
        this.setButton(this.action, this.type, this.resources.getAssetPath(this.action + "#" + this.type));
        return true;
    }

    public void setButton(String string, String string2, String string3) {
        CustomButton customButton = new CustomButton(string, string2, string3);
        CustomButton customButton2 = null;
        for (CustomButton customButton3 : this.adventureData.getButtons()) {
            if (!customButton3.equals((Object)customButton)) continue;
            customButton2 = customButton3;
        }
        if (customButton2 != null) {
            this.adventureData.getButtons().remove(customButton2);
        }
        System.out.println("Adding button: " + customButton.getAction() + "," + customButton.getType() + "," + customButton.getPath());
        this.adventureData.addButton(customButton);
    }
}

