/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.chapter.ExitLook;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.data.AssetInformation;

public class SelectAssetForEffectTool
extends SelectResourceTool {
    protected static final String ANIMATION_EFF = "anim";
    protected static final String AUDIO_EFF = "audio";
    protected ExitLook exitLook;

    protected static AssetInformation[] createAssetInfoArray() {
        AssetInformation[] assetInformationArray = new AssetInformation[]{new AssetInformation("", ANIMATION_EFF, true, 6, 0)};
        return assetInformationArray;
    }

    protected static Resources createResources(ExitLook exitLook) {
        Resources resources = new Resources();
        resources.addAsset(ANIMATION_EFF, exitLook.getCursorPath());
        return resources;
    }

    public SelectAssetForEffectTool(ExitLook exitLook) throws CloneNotSupportedException {
        super(SelectAssetForEffectTool.createResources(exitLook), SelectAssetForEffectTool.createAssetInfoArray(), 4, 0);
        this.exitLook = exitLook;
    }

    @Override
    public boolean undoTool() {
        boolean bl = super.undoTool();
        if (!bl) {
            return false;
        }
        this.exitLook.setCursorPath(this.resources.getAssetPath(ANIMATION_EFF));
        this.controller.reloadPanel();
        return true;
    }

    @Override
    public boolean redoTool() {
        boolean bl = super.redoTool();
        if (!bl) {
            return false;
        }
        this.exitLook.setCursorPath(this.resources.getAssetPath(ANIMATION_EFF));
        this.controller.reloadPanel();
        return true;
    }

    @Override
    public boolean doTool() {
        boolean bl = super.doTool();
        if (!bl) {
            return false;
        }
        this.exitLook.setCursorPath(this.resources.getAssetPath(ANIMATION_EFF));
        return true;
    }
}

