/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.CustomArrow;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.data.AssetInformation;

public class SelectArrowTool
extends SelectResourceTool {
    protected AdventureData adventureData;
    protected String type;
    protected boolean removed;

    protected static AssetInformation[] createAssetInfoArray(String string) {
        AssetInformation[] assetInformationArray = new AssetInformation[]{new AssetInformation("", string, true, 9, 0)};
        return assetInformationArray;
    }

    protected static Resources createResources(AdventureData adventureData, String string) {
        Resources resources = new Resources();
        boolean bl = false;
        for (int i = 0; i < adventureData.getArrows().size(); ++i) {
            CustomArrow customArrow = (CustomArrow)adventureData.getArrows().get(i);
            if (!customArrow.getType().equals(string)) continue;
            resources.addAsset(string, customArrow.getPath());
            bl = true;
            break;
        }
        if (!bl) {
            resources.addAsset(string, null);
        }
        return resources;
    }

    public SelectArrowTool(AdventureData adventureData, String string) throws CloneNotSupportedException {
        super(SelectArrowTool.createResources(adventureData, string), SelectArrowTool.createAssetInfoArray(string), 34, 0);
        this.adventureData = adventureData;
        this.type = string;
    }

    @Override
    public boolean undoTool() {
        boolean bl = super.undoTool();
        if (!bl) {
            return false;
        }
        for (int i = 0; i < this.adventureData.getArrows().size(); ++i) {
            if (!((CustomArrow)this.adventureData.getArrows().get(i)).getType().equals(this.type)) continue;
            if (this.removed) {
                this.adventureData.getArrows().remove(i);
                break;
            }
            ((CustomArrow)this.adventureData.getArrows().get(i)).setPath(this.resources.getAssetPath(this.type));
            break;
        }
        this.controller.updatePanel();
        this.controller.dataModified();
        return true;
    }

    @Override
    public boolean redoTool() {
        boolean bl;
        if (this.removed) {
            this.adventureData.addArrow(this.type, "");
        }
        if (!(bl = super.redoTool())) {
            return false;
        }
        for (int i = 0; i < this.adventureData.getArrows().size(); ++i) {
            if (!((CustomArrow)this.adventureData.getArrows().get(i)).getType().equals(this.type)) continue;
            ((CustomArrow)this.adventureData.getArrows().get(i)).setPath(this.resources.getAssetPath(this.type));
        }
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean doTool() {
        int n;
        if (this.resources.getAssetPath(this.type) == null) {
            this.removed = false;
        } else {
            for (n = 0; n < this.adventureData.getArrows().size(); ++n) {
                CustomArrow customArrow = (CustomArrow)this.adventureData.getArrows().get(n);
                if (!customArrow.getType().equals(this.type)) continue;
                this.adventureData.getArrows().remove(customArrow);
                break;
            }
            this.removed = true;
        }
        n = super.doTool();
        if (n == 0) {
            return false;
        }
        this.setArrow(this.type, this.resources.getAssetPath(this.type));
        return true;
    }

    public void setArrow(String string, String string2) {
        CustomArrow customArrow = new CustomArrow(string, string2);
        CustomArrow customArrow2 = null;
        for (CustomArrow customArrow3 : this.adventureData.getArrows()) {
            if (!customArrow3.equals((Object)customArrow)) continue;
            customArrow2 = customArrow3;
        }
        if (customArrow2 != null) {
            this.adventureData.getArrows().remove(customArrow2);
        }
        this.adventureData.addArrow(customArrow);
    }
}

