/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.data.AssetInformation;

public abstract class ResourcesTool
extends Tool {
    protected Controller controller;
    protected Resources resources;
    protected Resources oldResources;
    protected AssetInformation[] assetsInformation;
    protected int resourcesType;
    protected int index;

    public ResourcesTool(Resources resources, AssetInformation[] assetInformationArray, int n, int n2) throws CloneNotSupportedException {
        this.resources = resources;
        this.assetsInformation = assetInformationArray;
        this.resourcesType = n;
        this.controller = Controller.getInstance();
        this.index = n2;
        this.oldResources = (Resources)resources.clone();
    }

    @Override
    public boolean undoTool() {
        try {
            String[] stringArray;
            Resources resources = (Resources)this.resources.clone();
            this.resources.clearAssets();
            for (String string : stringArray = this.oldResources.getAssetTypes()) {
                this.resources.addAsset(string, this.oldResources.getAssetPath(string));
            }
            this.oldResources.clearAssets();
            for (String string : stringArray = resources.getAssetTypes()) {
                this.oldResources.addAsset(string, resources.getAssetPath(string));
            }
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean redoTool() {
        return this.undoTool();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }
}

