/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class DuplicateResourcesBlockTool
extends Tool {
    private DataControl dataControl;
    protected List<Resources> resourcesList;
    protected List<ResourcesDataControl> resourcesDataControlList;
    private Resources newElement;
    private ResourcesDataControl newDataControl;
    private DataControlWithResources parent;

    public DuplicateResourcesBlockTool(DataControl dataControl, List<Resources> list, List<ResourcesDataControl> list2, DataControlWithResources dataControlWithResources) {
        this.dataControl = dataControl;
        this.resourcesList = list;
        this.resourcesDataControlList = list2;
        this.parent = dataControlWithResources;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (!(this.dataControl instanceof ResourcesDataControl)) {
            return false;
        }
        try {
            this.newElement = (Resources)((Resources)this.dataControl.getContent()).clone();
            this.newDataControl = new ResourcesDataControl(this.newElement, ((ResourcesDataControl)this.dataControl).getResourcesType());
            this.resourcesList.add(this.newElement);
            this.resourcesDataControlList.add(this.newDataControl);
            this.parent.setSelectedResources(this.resourcesList.size() - 1);
            return true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ReportDialog.GenerateErrorReport((Exception)cloneNotSupportedException, (boolean)true, (String)"Could not clone resources");
            return false;
        }
    }

    @Override
    public boolean redoTool() {
        this.resourcesList.add(this.newElement);
        this.resourcesDataControlList.add(this.newDataControl);
        this.parent.setSelectedResources(this.resourcesList.size() - 1);
        Controller.getInstance().reloadPanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        boolean bl;
        boolean bl2 = bl = this.resourcesList.remove(this.newElement) && this.resourcesDataControlList.remove(this.newDataControl);
        if (bl) {
            this.parent.setSelectedResources(this.resourcesList.size() - 1);
            Controller.getInstance().reloadPanel();
        }
        return bl;
    }
}

