/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class DeleteResourcesBlockTool
extends Tool {
    private List<Resources> resourcesList;
    private List<ResourcesDataControl> resourcesDataControlList;
    private DataControl dataControl;
    private DataControlWithResources parentDataControl;
    private int lastSelectedResources;
    private int resourcesIndex;

    public DeleteResourcesBlockTool(List<Resources> list, List<ResourcesDataControl> list2, DataControl dataControl, DataControlWithResources dataControlWithResources) {
        this.resourcesDataControlList = list2;
        this.resourcesList = list;
        this.dataControl = dataControl;
        this.parentDataControl = dataControlWithResources;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        this.lastSelectedResources = this.parentDataControl.getSelectedResources();
        if (this.resourcesList.size() > 1) {
            if (this.resourcesList.remove(this.dataControl.getContent())) {
                this.resourcesIndex = this.resourcesDataControlList.indexOf(this.dataControl);
                this.resourcesDataControlList.remove(this.dataControl);
                int n = this.parentDataControl.getSelectedResources();
                if (n > 0 && n >= this.resourcesIndex) {
                    this.parentDataControl.setSelectedResources(n - 1);
                }
                bl = true;
            }
        } else {
            Controller.getInstance().showErrorDialog(TC.get((String)"Operation.DeleteResourcesTitle"), TC.get((String)"Operation.DeleteResourcesErrorLastResources"));
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        boolean bl = this.doTool();
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        this.resourcesList.add(this.resourcesIndex, (Resources)this.dataControl.getContent());
        this.resourcesDataControlList.add(this.resourcesIndex, (ResourcesDataControl)this.dataControl);
        this.parentDataControl.setSelectedResources(this.lastSelectedResources);
        Controller.getInstance().reloadPanel();
        return true;
    }
}

