/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.CustomCursor;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteCursorTool
extends Tool {
    private AdventureData adventureData;
    private CustomCursor cursorDeleted;
    private int index;

    public DeleteCursorTool(AdventureData adventureData, int n) {
        this.adventureData = adventureData;
        this.index = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.cursorDeleted = (CustomCursor)this.adventureData.getCursors().remove(this.index);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.cursorDeleted = (CustomCursor)this.adventureData.getCursors().remove(this.index);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.adventureData.getCursors().add(this.index, this.cursorDeleted);
        Controller.getInstance().updatePanel();
        return true;
    }
}

