/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.adventure.AdventureData;
import es.eucm.eadventure.common.data.adventure.CustomButton;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteButtonTool
extends Tool {
    private AdventureData adventureData;
    private CustomButton cursorDeleted;
    private String action;
    private String type;
    private int index;

    public DeleteButtonTool(AdventureData adventureData, String string, String string2) {
        this.adventureData = adventureData;
        this.action = string;
        this.type = string2;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.cursorDeleted != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        CustomButton customButton = new CustomButton(this.action, this.type, null);
        for (int i = 0; i < this.adventureData.getButtons().size(); ++i) {
            CustomButton customButton2 = (CustomButton)this.adventureData.getButtons().get(i);
            if (!customButton2.equals((Object)customButton)) continue;
            this.cursorDeleted = (CustomButton)this.adventureData.getButtons().remove(i);
            this.index = i;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        this.adventureData.getButtons().remove(this.index);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.adventureData.getButtons().add(this.index, this.cursorDeleted);
        Controller.getInstance().updatePanel();
        return true;
    }
}

