/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.assets;

import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControlWithResources;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class AddResourcesBlockTool
extends Tool {
    private List<Resources> resourcesList;
    private List<ResourcesDataControl> resourcesDataControlList;
    private int resourcesType;
    private DataControlWithResources parent;
    private Resources newResources;
    private ResourcesDataControl newResourcesDataControl;

    public AddResourcesBlockTool(List<Resources> list, List<ResourcesDataControl> list2, int n, DataControlWithResources dataControlWithResources) {
        this.resourcesList = list;
        this.resourcesDataControlList = list2;
        this.resourcesType = n;
        this.parent = dataControlWithResources;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.newResources = new Resources();
        this.newResourcesDataControl = new ResourcesDataControl(this.newResources, this.resourcesType);
        this.resourcesList.add(this.newResources);
        this.resourcesDataControlList.add(this.newResourcesDataControl);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.resourcesList.add(this.newResources);
        this.resourcesDataControlList.add(this.newResourcesDataControl);
        this.parent.setSelectedResources(this.resourcesList.size() - 1);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        boolean bl;
        boolean bl2 = bl = this.resourcesList.remove(this.newResources) && this.resourcesDataControlList.remove(this.newResourcesDataControl);
        if (bl) {
            this.parent.setSelectedResources(this.resourcesList.size() - 1);
            Controller.getInstance().updatePanel();
        }
        return bl;
    }
}

