/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.areaedition;

import es.eucm.eadventure.common.data.chapter.InfluenceArea;
import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.common.data.chapter.elements.ActiveArea;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.scene.InfluenceAreaDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.awt.Point;

public class DeletePointTool
extends Tool {
    private Rectangle rectangle;
    private Point oldPoint;
    private int oldIndex;
    private InfluenceAreaDataControl iadc;
    private InfluenceArea oldInfluenceArea;
    private InfluenceArea newInfluenceArea;

    public DeletePointTool(Rectangle rectangle, Point point) {
        this.rectangle = rectangle;
        this.oldPoint = point;
        this.oldIndex = rectangle.getPoints().indexOf(point);
    }

    public DeletePointTool(Rectangle rectangle, Point point, InfluenceAreaDataControl influenceAreaDataControl) {
        this.rectangle = rectangle;
        this.oldPoint = point;
        this.oldIndex = rectangle.getPoints().indexOf(point);
        this.iadc = influenceAreaDataControl;
        this.oldInfluenceArea = (InfluenceArea)influenceAreaDataControl.getContent();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.rectangle.isRectangular()) {
            return false;
        }
        if (this.rectangle.getPoints().contains(this.oldPoint)) {
            this.rectangle.getPoints().remove(this.oldPoint);
            if (this.iadc != null && this.rectangle.getPoints().size() > 3) {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MAX_VALUE;
                int n3 = 0;
                int n4 = 0;
                for (Point point : this.rectangle.getPoints()) {
                    if (point.getX() > (double)n3) {
                        n3 = (int)point.getX();
                    }
                    if (point.getX() < (double)n) {
                        n = (int)point.getX();
                    }
                    if (point.getY() > (double)n4) {
                        n4 = (int)point.getY();
                    }
                    if (!(point.getY() < (double)n2)) continue;
                    n2 = (int)point.getY();
                }
                this.newInfluenceArea = new InfluenceArea();
                this.newInfluenceArea.setX(-20);
                this.newInfluenceArea.setY(-20);
                this.newInfluenceArea.setHeight(n4 - n2 + 40);
                this.newInfluenceArea.setWidth(n3 - n + 40);
                ActiveArea activeArea = (ActiveArea)this.rectangle;
                activeArea.setInfluenceArea(this.newInfluenceArea);
                this.iadc.setInfluenceArea(this.newInfluenceArea);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        if (this.rectangle.getPoints().contains(this.oldPoint)) {
            this.rectangle.getPoints().remove(this.oldPoint);
            if (this.iadc != null) {
                ActiveArea activeArea = (ActiveArea)this.rectangle;
                activeArea.setInfluenceArea(this.newInfluenceArea);
                this.iadc.setInfluenceArea(this.newInfluenceArea);
            }
            Controller.getInstance().reloadPanel();
            return true;
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        this.rectangle.getPoints().add(this.oldIndex, this.oldPoint);
        if (this.iadc != null) {
            ActiveArea activeArea = (ActiveArea)this.rectangle;
            activeArea.setInfluenceArea(this.oldInfluenceArea);
            this.iadc.setInfluenceArea(this.oldInfluenceArea);
        }
        Controller.getInstance().reloadPanel();
        return true;
    }
}

