/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.areaedition;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.awt.Point;

public class ChangePointValueTool
extends Tool {
    private Point point;
    private int x;
    private int y;
    private int originalX;
    private int originalY;

    public ChangePointValueTool(Point point, int n, int n2) {
        this.point = point;
        this.x = n;
        this.y = n2;
        this.originalX = (int)point.getX();
        this.originalY = (int)point.getY();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangePointValueTool) {
            ChangePointValueTool changePointValueTool = (ChangePointValueTool)tool;
            if (changePointValueTool.point == this.point) {
                changePointValueTool.x = this.x;
                changePointValueTool.y = this.y;
                changePointValueTool.timeStamp = this.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        this.point.setLocation(this.x, this.y);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.point.setLocation(this.x, this.y);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.point.setLocation(this.originalX, this.originalY);
        Controller.getInstance().updatePanel();
        return true;
    }
}

