/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.actions;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ActionsListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DuplicateActionTool
extends Tool {
    private ActionsListDataControl dataControl;
    private int position;
    private ActionDataControl newAction;

    public DuplicateActionTool(ActionsListDataControl actionsListDataControl, int n) {
        this.dataControl = actionsListDataControl;
        this.position = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.duplicateElement(this.dataControl.getActions().get(this.position))) {
            this.newAction = this.dataControl.getLastAction();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getActions().add(this.newAction);
        this.dataControl.getActionsList().add((Action)this.newAction.getContent());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newAction, false);
        Controller.getInstance().updatePanel();
        return true;
    }
}

