/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general.actions;

import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.general.ActionDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ActionsListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteActionTool
extends Tool {
    private ActionsListDataControl dataControl;
    private ActionDataControl element;
    private int position;

    public DeleteActionTool(ActionsListDataControl actionsListDataControl, int n) {
        this.dataControl = actionsListDataControl;
        this.position = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.element = this.dataControl.getActions().get(this.position);
        this.dataControl.deleteElement(this.element, false);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.deleteElement(this.element, true);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.getActions().add(this.position, this.element);
        this.dataControl.getActionsList().add(this.position, (Action)this.element.getContent());
        Controller.getInstance().updatePanel();
        return true;
    }
}

