/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general;

import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ChapterListDataControl;
import es.eucm.eadventure.editor.control.controllers.scene.SceneDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;

public class SwapPlayerModeTool
extends Tool {
    private boolean showConfirmation;
    private Controller controller;
    private AdventureDataControl adventureData;
    private ChapterListDataControl chapterDataControlList;
    private ArrayList<Integer> oldPlayerLayer;

    public SwapPlayerModeTool(boolean bl, AdventureDataControl adventureDataControl, ChapterListDataControl chapterListDataControl) {
        this.showConfirmation = bl;
        this.adventureData = adventureDataControl;
        this.controller = Controller.getInstance();
        this.chapterDataControlList = chapterListDataControl;
        this.oldPlayerLayer = new ArrayList();
        for (SceneDataControl sceneDataControl : chapterListDataControl.getSelectedChapterDataControl().getScenesList().getScenes()) {
            this.oldPlayerLayer.add(sceneDataControl.getPlayerLayer());
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = this.action();
        return bl;
    }

    @Override
    public boolean redoTool() {
        boolean bl = this.action();
        this.controller.reloadData();
        return bl;
    }

    @Override
    public boolean undoTool() {
        this.showConfirmation = false;
        boolean bl = this.action();
        for (int i = 0; i < this.oldPlayerLayer.size(); ++i) {
            Integer n = this.oldPlayerLayer.get(i);
            Scene scene = (Scene)this.chapterDataControlList.getSelectedChapterData().getScenes().get(i);
            scene.setPlayerLayer(n.intValue());
            if (n != -2 && n != -1) {
                this.chapterDataControlList.getSelectedChapterDataControl().getScenesList().getScenes().get(i).insertPlayer();
            }
            scene.setAllowPlayerLayer(this.oldPlayerLayer.get(i) != -2);
        }
        this.controller.reloadData();
        return bl;
    }

    private boolean action() {
        boolean bl = true;
        if (this.showConfirmation) {
            bl = this.controller.showStrictConfirmDialog(TC.get((String)"SwapPlayerMode.Title"), TC.get((String)"SwapPlayerMode.Message"));
        }
        if (bl) {
            if (this.adventureData.getPlayerMode() == 0) {
                this.adventureData.setPlayerMode(1);
                this.chapterDataControlList.addPlayerToAllScenesChapters();
                this.controller.changePlayerNecessaryResources(true);
                return true;
            }
            if (this.adventureData.getPlayerMode() == 1) {
                this.adventureData.setPlayerMode(0);
                this.chapterDataControlList.deletePlayerToAllScenesChapters();
                this.controller.changePlayerNecessaryResources(false);
                return true;
            }
        }
        return false;
    }
}

