/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general;

import es.eucm.eadventure.editor.control.controllers.scene.ElementContainer;
import es.eucm.eadventure.editor.control.controllers.scene.ReferencesListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.elementpanels.scene.ElementReferencesTable;

public class MovePlayerLayerInTableTool
extends Tool {
    private ElementReferencesTable table;
    private ReferencesListDataControl referencesListDataControl;
    private boolean moveUp;
    private ElementContainer element;
    private int selectedRow;

    public MovePlayerLayerInTableTool(ReferencesListDataControl referencesListDataControl, ElementReferencesTable elementReferencesTable, boolean bl) {
        this.referencesListDataControl = referencesListDataControl;
        this.table = elementReferencesTable;
        this.moveUp = bl;
        this.selectedRow = this.table.getSelectedRow();
        this.element = this.referencesListDataControl.getAllReferencesDataControl().get(this.selectedRow);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.action(this.moveUp);
        return true;
    }

    private void action(boolean bl) {
        if (!bl && this.referencesListDataControl.moveElementDown(this.element.getErdc())) {
            this.table.getSelectionModel().setSelectionInterval(this.selectedRow + 1, this.selectedRow + 1);
            this.table.updateUI();
        }
        if (bl && this.referencesListDataControl.moveElementUp(this.element.getErdc())) {
            this.table.getSelectionModel().setSelectionInterval(this.selectedRow - 1, this.selectedRow - 1);
            this.table.updateUI();
        }
        this.moveUp = !this.moveUp;
    }

    @Override
    public boolean redoTool() {
        this.action(this.moveUp);
        return true;
    }

    @Override
    public boolean undoTool() {
        this.action(this.moveUp);
        return true;
    }
}

