/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general;

import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeTransitionTypeTool
extends Tool {
    private int newType;
    private int oldType;
    private NextScene nextScene;

    public ChangeTransitionTypeTool(NextScene nextScene, int n) {
        this.newType = n;
        this.oldType = nextScene.getTransitionType();
        this.nextScene = nextScene;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.newType == this.oldType) {
            return false;
        }
        this.nextScene.setTransitionType(this.newType);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.nextScene.setTransitionType(this.newType);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.nextScene.setTransitionType(this.oldType);
        Controller.getInstance().updatePanel();
        return true;
    }
}

