/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general;

import es.eucm.eadventure.common.data.chapter.NextScene;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeTransitionTimeTool
extends Tool {
    private int newTime;
    private int oldTime;
    private NextScene nextScene;

    public ChangeTransitionTimeTool(NextScene nextScene, int n) {
        this.oldTime = nextScene.getTransitionTime();
        this.newTime = n;
        this.nextScene = nextScene;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeTransitionTimeTool) {
            ChangeTransitionTimeTool changeTransitionTimeTool = (ChangeTransitionTimeTool)tool;
            if (changeTransitionTimeTool.nextScene == this.nextScene) {
                this.timeStamp = changeTransitionTimeTool.timeStamp;
                this.newTime = changeTransitionTimeTool.newTime;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.oldTime == this.newTime) {
            return false;
        }
        this.nextScene.setTransitionTime(this.newTime);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.nextScene.setTransitionTime(this.newTime);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.nextScene.setTransitionTime(this.oldTime);
        Controller.getInstance().updatePanel();
        return true;
    }
}

