/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general;

import es.eucm.eadventure.common.data.chapter.Rectangle;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeRectangleValueTool
extends Tool {
    private Rectangle rectangle;
    private int x;
    private int y;
    private int width;
    private int height;
    private int oldX;
    private int oldY;
    private int oldWidth;
    private int oldHeight;

    public ChangeRectangleValueTool(Rectangle rectangle, int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.rectangle = rectangle;
        this.oldX = rectangle.getX();
        this.oldY = rectangle.getY();
        this.oldWidth = rectangle.getWidth();
        this.oldHeight = rectangle.getHeight();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeRectangleValueTool) {
            ChangeRectangleValueTool changeRectangleValueTool = (ChangeRectangleValueTool)tool;
            if (changeRectangleValueTool.rectangle != this.rectangle) {
                return false;
            }
            if (changeRectangleValueTool.isChangePos() && this.isChangePos()) {
                this.x = changeRectangleValueTool.x;
                this.y = changeRectangleValueTool.y;
                this.timeStamp = changeRectangleValueTool.timeStamp;
                return true;
            }
            if (changeRectangleValueTool.isChangeSize() && this.isChangeSize()) {
                this.width = changeRectangleValueTool.width;
                this.height = changeRectangleValueTool.height;
                this.timeStamp = changeRectangleValueTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        this.rectangle.setValues(this.x, this.y, this.width, this.height);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.rectangle.setValues(this.x, this.y, this.width, this.height);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.rectangle.setValues(this.oldX, this.oldY, this.oldWidth, this.oldHeight);
        Controller.getInstance().updatePanel();
        return true;
    }

    private boolean isChangeSize() {
        return this.x == this.oldX && this.y == this.oldY;
    }

    private boolean isChangePos() {
        return this.width == this.oldWidth && this.height == this.oldHeight;
    }
}

