/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general;

import es.eucm.eadventure.common.data.Positioned;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;

public class ChangePositionTool
extends Tool {
    protected int oldX;
    protected int oldY;
    protected int x;
    protected int y;
    protected Positioned data;
    protected List<ChangePositionToolListener> listeners;

    public ChangePositionTool(Positioned positioned, int n, int n2) {
        this.oldX = positioned.getPositionX();
        this.oldY = positioned.getPositionY();
        this.x = n;
        this.y = n2;
        this.data = positioned;
        this.listeners = new ArrayList<ChangePositionToolListener>();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangePositionTool) {
            ChangePositionTool changePositionTool = (ChangePositionTool)tool;
            if (changePositionTool.data == this.data) {
                this.x = changePositionTool.x;
                this.y = changePositionTool.y;
                this.timeStamp = changePositionTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (this.x != this.data.getPositionX() || this.y != this.data.getPositionY()) {
            this.data.setPositionX(this.x);
            this.data.setPositionY(this.y);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        return this.undoTool();
    }

    @Override
    public boolean undoTool() {
        this.data.setPositionX(this.oldX);
        this.data.setPositionY(this.oldY);
        int n = this.oldX;
        int n2 = this.oldY;
        this.oldX = this.x;
        this.oldY = this.y;
        this.x = n;
        this.y = n2;
        for (ChangePositionToolListener changePositionToolListener : this.listeners) {
            changePositionToolListener.positionUpdated(this.oldX, this.oldY);
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    public void addListener(ChangePositionToolListener changePositionToolListener) {
    }

    public static interface ChangePositionToolListener {
        public void positionUpdated(int var1, int var2);
    }
}

