/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.general;

import es.eucm.eadventure.common.data.chapter.ElementReference;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeElementReferenceTool
extends Tool {
    private ElementReference elementReference;
    private int x;
    private int y;
    private int oldX;
    private int oldY;
    private boolean changePosition;
    private boolean changeScale;
    private float scale;
    private float oldScale;

    public ChangeElementReferenceTool(ElementReference elementReference, int n, int n2) {
        this.elementReference = elementReference;
        this.x = n;
        this.y = n2;
        this.oldX = elementReference.getX();
        this.oldY = elementReference.getY();
        this.changePosition = true;
        this.changeScale = false;
    }

    public ChangeElementReferenceTool(ElementReference elementReference, float f) {
        this.elementReference = elementReference;
        this.scale = f;
        this.oldScale = this.elementReference.getScale();
        this.changePosition = false;
        this.changeScale = true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeElementReferenceTool) {
            ChangeElementReferenceTool changeElementReferenceTool = (ChangeElementReferenceTool)tool;
            if (changeElementReferenceTool.elementReference != this.elementReference) {
                return false;
            }
            if (changeElementReferenceTool.changePosition && this.changePosition) {
                this.x = changeElementReferenceTool.x;
                this.y = changeElementReferenceTool.y;
                this.timeStamp = changeElementReferenceTool.timeStamp;
                return true;
            }
            if (changeElementReferenceTool.changeScale && this.changeScale) {
                this.scale = changeElementReferenceTool.scale;
                this.timeStamp = changeElementReferenceTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.changeScale) {
            this.elementReference.setScale(this.scale);
        } else if (this.changePosition) {
            this.elementReference.setPosition(this.x, this.y);
        }
        return true;
    }

    @Override
    public String getToolName() {
        return null;
    }

    @Override
    public boolean redoTool() {
        if (this.changeScale) {
            this.elementReference.setScale(this.scale);
        } else if (this.changePosition) {
            this.elementReference.setPosition(this.x, this.y);
        }
        Controller.getInstance().reloadPanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        if (this.changeScale) {
            this.elementReference.setScale(this.oldScale);
        } else if (this.changePosition) {
            this.elementReference.setPosition(this.oldX, this.oldY);
        }
        Controller.getInstance().reloadPanel();
        return true;
    }
}

