/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.tools.general.assets.SelectResourceTool;
import es.eucm.eadventure.editor.data.AssetInformation;

public class SelectLineAudioPathTool
extends SelectResourceTool {
    protected static final String AUDIO_STR = "audio";
    protected ConversationLine line;

    protected static AssetInformation[] createAssetInfoArray() {
        AssetInformation[] assetInformationArray = new AssetInformation[]{new AssetInformation("", AUDIO_STR, true, 4, 0)};
        return assetInformationArray;
    }

    protected static Resources createResources(ConversationLine conversationLine) {
        Resources resources = new Resources();
        if (conversationLine.getAudioPath() != null) {
            resources.addAsset(AUDIO_STR, conversationLine.getAudioPath());
        }
        return resources;
    }

    public SelectLineAudioPathTool(ConversationLine conversationLine) throws CloneNotSupportedException {
        super(SelectLineAudioPathTool.createResources(conversationLine), SelectLineAudioPathTool.createAssetInfoArray(), 33, 0);
        this.line = conversationLine;
    }

    @Override
    public boolean undoTool() {
        boolean bl = super.undoTool();
        if (!bl) {
            return false;
        }
        this.line.setAudioPath(this.resources.getAssetPath(AUDIO_STR));
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean redoTool() {
        boolean bl = super.redoTool();
        if (!bl) {
            return false;
        }
        this.line.setAudioPath(this.resources.getAssetPath(AUDIO_STR));
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean doTool() {
        boolean bl = super.doTool();
        if (!bl) {
            return false;
        }
        this.line.setAudioPath(this.resources.getAssetPath(AUDIO_STR));
        return true;
    }
}

