/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class MoveNodeLineTool
extends Tool {
    public static final int UP = 1;
    public static final int DOWN = 2;
    protected ConversationNode parent;
    protected int lineIndex;
    protected int mode;

    public MoveNodeLineTool(ConversationNodeView conversationNodeView, int n, int n2) {
        this((ConversationNode)conversationNodeView, n, n2);
    }

    public MoveNodeLineTool(ConversationNode conversationNode, int n, int n2) {
        this.parent = conversationNode;
        this.lineIndex = n;
        this.mode = n2;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.mode == 1) {
            return this.moveUp();
        }
        if (this.mode == 2) {
            return this.moveDown();
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        boolean bl = false;
        if (this.mode == 1) {
            bl = this.moveUp();
        } else if (this.mode == 2) {
            bl = this.moveDown();
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        boolean bl = false;
        if (this.mode == 1) {
            bl = this.moveDown();
        } else if (this.mode == 2) {
            bl = this.moveUp();
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    protected boolean moveDown() {
        boolean bl = false;
        if (this.lineIndex < this.parent.getLineCount() - 1) {
            this.parent.addLine(this.lineIndex + 1, this.parent.removeLine(this.lineIndex));
            if (this.parent.getType() == 1) {
                ConversationNode conversationNode = this.parent.removeChild(this.lineIndex);
                this.parent.addChild(this.lineIndex + 1, conversationNode);
            }
            bl = true;
        }
        return bl;
    }

    protected boolean moveUp() {
        boolean bl = false;
        if (this.lineIndex > 0) {
            this.parent.addLine(this.lineIndex - 1, this.parent.removeLine(this.lineIndex));
            if (this.parent.getType() == 1) {
                ConversationNode conversationNode = this.parent.removeChild(this.lineIndex);
                this.parent.addChild(this.lineIndex - 1, conversationNode);
            }
            bl = true;
        }
        return bl;
    }
}

