/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class LinkConversationNodeTool
extends Tool {
    private ConversationNodeView fatherView;
    private ConversationNodeView childView;
    private Controller controller;
    private ConversationDataControl dataControl;

    public LinkConversationNodeTool(ConversationDataControl conversationDataControl, ConversationNodeView conversationNodeView, ConversationNodeView conversationNodeView2) {
        this.fatherView = conversationNodeView;
        this.childView = conversationNodeView2;
        this.dataControl = conversationDataControl;
        this.controller = Controller.getInstance();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (!this.dataControl.canLinkNodeTo(this.fatherView, this.childView)) {
            this.controller.showErrorDialog(TC.get((String)"Conversation.OperationLinkNode"), TC.get((String)"Conversation.ErrorLinkNode"));
        } else {
            boolean bl2 = true;
            if (bl2) {
                ConversationNode conversationNode = (ConversationNode)this.fatherView;
                ConversationNode conversationNode2 = (ConversationNode)this.childView;
                conversationNode.addChild(conversationNode2);
                if (conversationNode.getType() == 1) {
                    conversationNode.addLine(new ConversationLine("Player", TC.get((String)"ConversationLine.DefaultText")));
                }
                bl = true;
                this.dataControl.updateAllConditions();
            }
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        ConversationNode conversationNode = (ConversationNode)this.fatherView;
        ConversationNode conversationNode2 = (ConversationNode)this.childView;
        conversationNode.addChild(conversationNode2);
        if (conversationNode.getType() == 1) {
            conversationNode.addLine(new ConversationLine("Player", TC.get((String)"ConversationLine.DefaultText")));
        }
        this.dataControl.updateAllConditions();
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        ConversationNode conversationNode = (ConversationNode)this.fatherView;
        ConversationNode conversationNode2 = (ConversationNode)this.childView;
        int n = -1;
        for (int i = 0; i < conversationNode.getChildCount(); ++i) {
            if (conversationNode.getChild(i) != conversationNode2) continue;
            n = i;
            conversationNode.removeChild(i);
            break;
        }
        if (conversationNode.getType() == 1 && n != -1) {
            conversationNode.removeLine(n);
        }
        this.dataControl.updateAllConditions();
        this.controller.updatePanel();
        return true;
    }
}

