/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.tools.conversation.DeleteNodeLinkTool;

public class DeleteNodeOptionTool
extends DeleteNodeLinkTool {
    protected ConversationLine deletedLine;

    public DeleteNodeOptionTool(ConversationNode conversationNode, int n) {
        super(conversationNode);
        this.confirmText = TC.get((String)"Conversation.ConfirmationDeleteOption");
        this.confirmTitle = TC.get((String)"Conversation.OperationDeleteOption");
        this.linkIndex = n;
    }

    public DeleteNodeOptionTool(ConversationNodeView conversationNodeView, int n) {
        super(conversationNodeView);
        this.confirmText = TC.get((String)"Conversation.ConfirmationDeleteOption");
        this.confirmTitle = TC.get((String)"Conversation.OperationDeleteOption");
        this.linkIndex = n;
    }

    @Override
    public boolean doTool() {
        boolean bl = super.doTool();
        if (bl) {
            this.deletedLine = this.parent.getLine(this.linkIndex);
            this.parent.removeLine(this.linkIndex);
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        boolean bl = super.undoTool();
        if (bl) {
            this.parent.addLine(this.linkIndex, this.deletedLine);
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        boolean bl = super.redoTool();
        if (bl) {
            this.parent.removeLine(this.linkIndex);
        }
        return bl;
    }
}

