/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteNodeLinkTool
extends Tool {
    protected ConversationNode parent;
    protected int linkIndex;
    protected ConversationNode linkDeleted;
    protected String confirmTitle;
    protected String confirmText;

    public DeleteNodeLinkTool(ConversationNodeView conversationNodeView) {
        this((ConversationNode)conversationNodeView);
    }

    public DeleteNodeLinkTool(ConversationNode conversationNode) {
        this.parent = conversationNode;
        this.linkIndex = 0;
        this.confirmTitle = TC.get((String)"Conversation.OperationDeleteLink");
        this.confirmText = TC.get((String)"Conversation.ConfirmationDeleteLink");
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.linkDeleted != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (Controller.getInstance().showStrictConfirmDialog(this.confirmTitle, this.confirmText)) {
            this.linkDeleted = this.parent.removeChild(this.linkIndex);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.parent.removeChild(this.linkIndex);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.parent.addChild(this.linkIndex, this.linkDeleted);
        Controller.getInstance().updatePanel();
        return true;
    }
}

