/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class DeleteNodeLineTool
extends Tool {
    protected ConversationNode parent;
    protected int lineIndex;
    protected ConversationLine lineDeleted;
    protected List<ConditionsController> node;
    protected ConditionsController conditionDeleted;

    public DeleteNodeLineTool(ConversationNodeView conversationNodeView, int n, List<ConditionsController> list) {
        this((ConversationNode)conversationNodeView, n, list);
    }

    public DeleteNodeLineTool(ConversationNode conversationNode, int n, List<ConditionsController> list) {
        this.parent = conversationNode;
        this.lineIndex = n;
        this.node = list;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.lineDeleted != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.lineDeleted = this.parent.getLine(this.lineIndex);
        this.parent.removeLine(this.lineIndex);
        this.conditionDeleted = this.node.remove(this.lineIndex);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.parent.removeLine(this.lineIndex);
        this.node.remove(this.lineIndex);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.parent.addLine(this.lineIndex, this.lineDeleted);
        this.node.add(this.lineIndex, this.conditionDeleted);
        Controller.getInstance().updatePanel();
        return true;
    }
}

