/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.conversation.GraphConversation;
import es.eucm.eadventure.common.data.chapter.conversation.TreeConversation;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeleteConversationNodeTool
extends Tool {
    public static final int MODE_GRAPH = 1;
    public static final int MODE_TREE = 2;
    private boolean showConfirmation;
    private int mode;
    private Controller controller;
    private ConversationNodeView nodeView;
    private ConversationNode rootNode;
    private Conversation conversation;
    private ConversationLine deletedLine;
    private ConversationNode deletedNode;
    private ConversationNode parentNode;
    private List<ConditionsController> deletedConditions;
    private ConditionsController deletedCondition;
    private int index;
    private Map<ConversationNodeView, List<ConditionsController>> allConditions;

    public DeleteConversationNodeTool(int n, ConversationNodeView conversationNodeView, Conversation conversation, Map<ConversationNodeView, List<ConditionsController>> map) {
        this.mode = n;
        this.showConfirmation = n == 2;
        this.controller = Controller.getInstance();
        this.nodeView = conversationNodeView;
        this.conversation = conversation;
        this.rootNode = conversation.getRootNode();
        this.allConditions = map;
    }

    public DeleteConversationNodeTool(ConversationNodeView conversationNodeView, GraphConversation graphConversation, Map<ConversationNodeView, List<ConditionsController>> map) {
        this(1, conversationNodeView, (Conversation)graphConversation, map);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.deletedNode != null && this.mode != 2;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = false;
        if (!this.showConfirmation || this.controller.showStrictConfirmDialog(TC.get((String)"Conversation.OperationDeleteNode"), TC.get((String)"Conversation.ConfirmDeleteNode"))) {
            ConversationNode conversationNode = (ConversationNode)this.nodeView;
            if (this.mode == 2) {
                if (this.recursiveDeleteNode(this.rootNode, conversationNode)) {
                    bl = true;
                }
            } else if (this.mode == 1) {
                List<ConversationNodeView> list = this.getAllNodes(this.conversation);
                for (ConversationNodeView conversationNodeView : list) {
                    int n = 0;
                    while (n < conversationNodeView.getChildCount()) {
                        if (conversationNodeView.getChildView(n) == this.nodeView) {
                            this.parentNode = (ConversationNode)conversationNodeView;
                            this.deletedNode = this.parentNode.removeChild(n);
                            this.index = n;
                            this.deletedConditions = this.allConditions.remove(this.deletedNode);
                            if (this.parentNode.getType() == 1) {
                                this.deletedLine = this.parentNode.removeLine(n);
                                this.deletedCondition = this.allConditions.get(this.parentNode).remove(n);
                            }
                            bl = true;
                            continue;
                        }
                        ++n;
                    }
                }
            }
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        this.parentNode.removeChild(this.index);
        this.allConditions.remove(this.deletedNode);
        if (this.parentNode.getType() == 1) {
            this.parentNode.removeLine(this.index);
            this.allConditions.get(this.parentNode).remove(this.index);
        }
        this.controller.updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.parentNode.addChild(this.index, this.deletedNode);
        this.allConditions.put((ConversationNodeView)this.deletedNode, this.deletedConditions);
        if (this.parentNode.getType() == 1) {
            this.parentNode.addLine(this.index, this.deletedLine);
            this.allConditions.get(this.deletedNode).add(this.index, this.deletedCondition);
        }
        this.controller.reloadPanel();
        return true;
    }

    private boolean recursiveDeleteNode(ConversationNode conversationNode, ConversationNode conversationNode2) {
        boolean bl = false;
        if (conversationNode.getType() == 0) {
            if (!conversationNode.isTerminal() && !TreeConversation.thereIsGoBackTag((ConversationNodeView)conversationNode)) {
                if (conversationNode.getChild(0) == conversationNode2) {
                    conversationNode.removeChild(0);
                    bl = true;
                } else {
                    bl = this.recursiveDeleteNode(conversationNode.getChild(0), conversationNode2);
                }
            }
        } else if (conversationNode.getType() == 1) {
            int n = 0;
            while (n < conversationNode.getChildCount()) {
                if (conversationNode.getChild(n) == conversationNode2) {
                    conversationNode.removeChild(n);
                    conversationNode.removeLine(n);
                    bl = true;
                    continue;
                }
                bl = bl || this.recursiveDeleteNode(conversationNode.getChild(n), conversationNode2);
                ++n;
            }
        }
        return bl;
    }

    public List<ConversationNodeView> getAllNodes(Conversation conversation) {
        List list = conversation.getAllNodes();
        ArrayList<ConversationNodeView> arrayList = new ArrayList<ConversationNodeView>();
        for (ConversationNode conversationNode : list) {
            arrayList.add((ConversationNodeView)conversationNode);
        }
        return arrayList;
    }
}

