/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class AddNodeLineTool
extends Tool {
    protected ConversationNode parent;
    protected int lineIndex;
    protected ConversationLine lineAdded;
    protected String name;
    protected List<ConditionsController> node;

    public AddNodeLineTool(ConversationNodeView conversationNodeView, int n, String string, List<ConditionsController> list) {
        this((ConversationNode)conversationNodeView, n, string, list);
    }

    public AddNodeLineTool(ConversationNode conversationNode, int n, String string, List<ConditionsController> list) {
        this.parent = conversationNode;
        this.lineIndex = n;
        this.name = string;
        this.node = list;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.lineAdded != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.lineAdded = new ConversationLine(this.name, TC.get((String)"ConversationLine.DefaultText"));
        this.parent.addLine(this.lineIndex, this.lineAdded);
        this.node.add(this.lineIndex, new ConditionsController(this.lineAdded.getConditions(), 331, Integer.toString(this.lineIndex)));
        return true;
    }

    @Override
    public boolean redoTool() {
        this.parent.addLine(this.lineIndex, this.lineAdded);
        this.node.add(this.lineIndex, new ConditionsController(this.lineAdded.getConditions(), 331, Integer.toString(this.lineIndex)));
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.parent.removeLine(this.lineIndex);
        this.node.remove(this.lineIndex);
        Controller.getInstance().updatePanel();
        return true;
    }
}

