/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.conversation;

import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.data.chapter.conversation.node.DialogueConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.OptionConversationNode;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AddConversationNodeTool
extends Tool {
    protected ConversationNode newChild;
    protected ConversationNode parent;
    protected int index;
    protected int nodeType;
    protected Map<ConversationNodeView, List<ConditionsController>> allConditions;

    public AddConversationNodeTool(ConversationNode conversationNode, int n, Map<ConversationNodeView, List<ConditionsController>> map) {
        this.parent = conversationNode;
        this.nodeType = n;
        this.allConditions = map;
    }

    public AddConversationNodeTool(ConversationNodeView conversationNodeView, int n, Map<ConversationNodeView, List<ConditionsController>> map) {
        this.parent = (ConversationNode)conversationNodeView;
        this.nodeType = n;
        this.allConditions = map;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.index != -1 && this.newChild != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = true;
        if (bl) {
            if (this.nodeType == 0) {
                this.newChild = new DialogueConversationNode();
            }
            if (this.nodeType == 1) {
                this.newChild = new OptionConversationNode();
            }
            if (this.newChild != null) {
                this.parent.addChild(this.newChild);
                this.allConditions.put((ConversationNodeView)this.newChild, new ArrayList());
                if (this.parent.getType() == 1) {
                    this.parent.addLine(new ConversationLine("Player", TC.get((String)"ConversationLine.NewOption")));
                    this.allConditions.get(this.parent).add(new ConditionsController(new Conditions(), 331, Integer.toString(0)));
                }
                this.index = -1;
                for (int i = 0; i < this.parent.getChildCount(); ++i) {
                    if (this.parent.getChild(i) != this.newChild) continue;
                    this.index = i;
                    break;
                }
            }
        }
        return this.newChild != null;
    }

    @Override
    public boolean redoTool() {
        this.parent.addChild(this.index, this.newChild);
        this.allConditions.put((ConversationNodeView)this.newChild, new ArrayList());
        if (this.parent.getType() == 1) {
            this.parent.addLine(this.index, new ConversationLine("Player", TC.get((String)"ConversationLine.NewOption")));
            this.allConditions.get(this.parent).add(new ConditionsController(new Conditions(), 331, Integer.toString(0)));
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.parent.removeChild(this.index);
        this.allConditions.remove(this.newChild);
        if (this.parent.getType() == 1) {
            this.parent.removeLine(this.index);
            this.allConditions.get(this.parent).remove(this.index);
        }
        Controller.getInstance().updatePanel();
        return true;
    }
}

