/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class MoveParagraphElementUpTool
extends Tool {
    private List<BookParagraph> bookParagraphsList;
    private List<BookParagraphDataControl> bookParagraphsDataControlList;
    private DataControl elementDataControl;
    private int oldElementIndex;
    private int newElementIndex;

    public MoveParagraphElementUpTool(BookDataControl bookDataControl, BookParagraphDataControl bookParagraphDataControl) {
        this.bookParagraphsList = bookDataControl.getBookParagraphsList().getBookParagraphsList();
        this.bookParagraphsDataControlList = bookDataControl.getBookParagraphsList().getBookParagraphs();
        this.elementDataControl = bookParagraphDataControl;
        this.oldElementIndex = this.bookParagraphsList.indexOf(this.elementDataControl.getContent());
        this.newElementIndex = this.oldElementIndex - 1;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof MoveParagraphElementUpTool) {
            MoveParagraphElementUpTool moveParagraphElementUpTool = (MoveParagraphElementUpTool)tool;
            if (moveParagraphElementUpTool.elementDataControl == this.elementDataControl) {
                this.newElementIndex = moveParagraphElementUpTool.newElementIndex;
                this.timeStamp = moveParagraphElementUpTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.oldElementIndex > 0) {
            this.bookParagraphsList.add(this.newElementIndex, this.bookParagraphsList.remove(this.oldElementIndex));
            this.bookParagraphsDataControlList.add(this.newElementIndex, this.bookParagraphsDataControlList.remove(this.oldElementIndex));
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.bookParagraphsList.add(this.newElementIndex, this.bookParagraphsList.remove(this.oldElementIndex));
        this.bookParagraphsDataControlList.add(this.newElementIndex, this.bookParagraphsDataControlList.remove(this.oldElementIndex));
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookParagraphsList.add(this.oldElementIndex, this.bookParagraphsList.remove(this.newElementIndex));
        this.bookParagraphsDataControlList.add(this.oldElementIndex, this.bookParagraphsDataControlList.remove(this.newElementIndex));
        Controller.getInstance().updatePanel();
        return true;
    }
}

