/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class MoveBookPageDownTool
extends Tool {
    private List<BookPage> bookPagesList;
    private BookPage bookPage;
    private int oldElementIndex;
    private int newElementIndex;

    public MoveBookPageDownTool(List<BookPage> list, BookPage bookPage) {
        this.bookPagesList = list;
        this.bookPage = bookPage;
        this.oldElementIndex = list.indexOf(this.bookPage);
        this.newElementIndex = this.oldElementIndex + 1;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof MoveBookPageDownTool) {
            MoveBookPageDownTool moveBookPageDownTool = (MoveBookPageDownTool)tool;
            if (moveBookPageDownTool.bookPage == this.bookPage) {
                this.newElementIndex = moveBookPageDownTool.newElementIndex;
                this.timeStamp = moveBookPageDownTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.oldElementIndex < this.bookPagesList.size() - 1) {
            this.bookPagesList.add(this.newElementIndex, this.bookPagesList.remove(this.oldElementIndex));
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.bookPagesList.add(this.newElementIndex, this.bookPagesList.remove(this.oldElementIndex));
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookPagesList.add(this.oldElementIndex, this.bookPagesList.remove(this.newElementIndex));
        Controller.getInstance().updatePanel();
        return true;
    }
}

