/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class DeleteParagraphElementTool
extends Tool {
    private List<BookParagraph> bookParagraphsList;
    private List<BookParagraphDataControl> bookParagraphsDataControlList;
    private DataControl elementDataControl;
    private int listIndex;
    private int dataControlListIndex;

    public DeleteParagraphElementTool(BookDataControl bookDataControl, BookParagraphDataControl bookParagraphDataControl) {
        this.bookParagraphsList = bookDataControl.getBookParagraphsList().getBookParagraphsList();
        this.bookParagraphsDataControlList = bookDataControl.getBookParagraphsList().getBookParagraphs();
        this.elementDataControl = bookParagraphDataControl;
        this.listIndex = this.bookParagraphsList.indexOf(this.elementDataControl.getContent());
        this.dataControlListIndex = this.bookParagraphsDataControlList.indexOf(this.elementDataControl);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        boolean bl = this.bookParagraphsList.remove(this.elementDataControl.getContent());
        if (bl) {
            this.bookParagraphsDataControlList.remove(this.elementDataControl);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        boolean bl = this.bookParagraphsList.remove(this.elementDataControl.getContent());
        if (bl) {
            this.bookParagraphsDataControlList.remove(this.elementDataControl);
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        this.bookParagraphsList.add(this.listIndex, (BookParagraph)this.elementDataControl.getContent());
        this.bookParagraphsDataControlList.add(this.dataControlListIndex, (BookParagraphDataControl)this.elementDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }
}

