/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class DeleteBookPageTool
extends Tool {
    private List<BookPage> bookPagesList;
    private BookPage bookPage;
    private int index;

    public DeleteBookPageTool(List<BookPage> list, BookPage bookPage) {
        this.bookPagesList = list;
        this.bookPage = bookPage;
        this.index = list.indexOf(this.bookPage);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        return this.bookPagesList.remove(this.bookPage);
    }

    @Override
    public boolean redoTool() {
        boolean bl = this.bookPagesList.remove(this.bookPage);
        Controller.getInstance().updatePanel();
        return bl;
    }

    @Override
    public boolean undoTool() {
        this.bookPagesList.add(this.index, this.bookPage);
        Controller.getInstance().updatePanel();
        return true;
    }
}

