/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeParagraphContentTool
extends Tool {
    private BookParagraph bookParagraph;
    private String newContent;
    private String oldContent;

    public ChangeParagraphContentTool(BookParagraph bookParagraph, String string) {
        this.bookParagraph = bookParagraph;
        this.newContent = string;
        this.oldContent = bookParagraph.getContent();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeParagraphContentTool) {
            ChangeParagraphContentTool changeParagraphContentTool = (ChangeParagraphContentTool)tool;
            if (changeParagraphContentTool.bookParagraph == this.bookParagraph) {
                this.newContent = changeParagraphContentTool.newContent;
                this.timeStamp = changeParagraphContentTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.oldContent != null && this.oldContent.equals(this.newContent)) {
            return false;
        }
        this.bookParagraph.setContent(this.newContent);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.bookParagraph.setContent(this.newContent);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookParagraph.setContent(this.oldContent);
        Controller.getInstance().updatePanel();
        return true;
    }
}

