/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeBookPageUriTool
extends Tool {
    private BookPage bookPage;
    private String newURI;
    private String oldURI;

    public ChangeBookPageUriTool(BookPage bookPage, String string) {
        this.bookPage = bookPage;
        this.newURI = string;
        this.oldURI = bookPage.getUri();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeBookPageUriTool) {
            ChangeBookPageUriTool changeBookPageUriTool = (ChangeBookPageUriTool)tool;
            if (changeBookPageUriTool.bookPage == this.bookPage) {
                this.newURI = changeBookPageUriTool.newURI;
                this.timeStamp = changeBookPageUriTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.oldURI != null || !this.newURI.equals(this.oldURI)) {
            this.bookPage.setUri(this.newURI);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.bookPage.setUri(this.newURI);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookPage.setUri(this.oldURI);
        Controller.getInstance().updatePanel();
        return true;
    }
}

