/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeBookPageTypeTool
extends Tool {
    private BookPage bookPage;
    private int newType;
    private int oldType;
    private String oldUri;

    public ChangeBookPageTypeTool(BookPage bookPage, int n) {
        this.bookPage = bookPage;
        this.newType = n;
        this.oldType = bookPage.getType();
        this.oldUri = bookPage.getUri();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.newType != this.oldType) {
            this.bookPage.setType(this.newType);
            if (this.newType == 1) {
                this.bookPage.setUri("");
            } else if (this.newType == 2) {
                this.bookPage.setUri("");
            } else {
                this.bookPage.setUri("http://www.");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.bookPage.setType(this.newType);
        if (this.newType == 1) {
            this.bookPage.setUri("");
        } else if (this.newType == 2) {
            this.bookPage.setUri("");
        } else {
            this.bookPage.setUri("http://www.");
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookPage.setType(this.oldType);
        this.bookPage.setUri(this.oldUri);
        Controller.getInstance().updatePanel();
        return true;
    }
}

