/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeBookPageScrollableTool
extends Tool {
    private BookPage bookPage;
    private boolean newScrollable;
    private boolean oldScrollable;

    public ChangeBookPageScrollableTool(BookPage bookPage, boolean bl) {
        this.bookPage = bookPage;
        this.newScrollable = bl;
        this.oldScrollable = bookPage.getScrollable();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.oldScrollable == this.newScrollable) {
            return false;
        }
        this.bookPage.setScrollable(this.newScrollable);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.bookPage.setScrollable(this.newScrollable);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookPage.setScrollable(this.oldScrollable);
        Controller.getInstance().updatePanel();
        return true;
    }
}

