/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeBookPageMarginsTool
extends Tool {
    private BookPage bookPage;
    private int newMargin;
    private int newMarginTop;
    private int newMarginBottom;
    private int newMarginEnd;
    private int oldMargin;
    private int oldMarginTop;
    private int oldMarginBottom;
    private int oldMarginEnd;

    public ChangeBookPageMarginsTool(BookPage bookPage, int n, int n2, int n3, int n4) {
        this.bookPage = bookPage;
        this.newMargin = n;
        this.newMarginTop = n2;
        this.newMarginBottom = n3;
        this.newMarginEnd = n4;
        this.oldMargin = bookPage.getMargin();
        this.oldMarginTop = bookPage.getMarginTop();
        this.oldMarginBottom = bookPage.getMarginBottom();
        this.oldMarginEnd = bookPage.getMarginEnd();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeBookPageMarginsTool) {
            ChangeBookPageMarginsTool changeBookPageMarginsTool = (ChangeBookPageMarginsTool)tool;
            if (changeBookPageMarginsTool.bookPage == this.bookPage) {
                if (this.oldMargin != this.newMargin && changeBookPageMarginsTool.oldMargin != changeBookPageMarginsTool.newMargin) {
                    this.newMargin = changeBookPageMarginsTool.newMargin;
                    this.timeStamp = changeBookPageMarginsTool.timeStamp;
                    return true;
                }
                if (this.oldMarginBottom != this.newMarginBottom && changeBookPageMarginsTool.oldMarginBottom != changeBookPageMarginsTool.newMarginBottom) {
                    this.oldMarginBottom = changeBookPageMarginsTool.oldMarginBottom;
                    this.timeStamp = changeBookPageMarginsTool.timeStamp;
                    return true;
                }
                if (this.oldMarginTop != this.newMarginTop && changeBookPageMarginsTool.oldMarginTop != changeBookPageMarginsTool.newMarginTop) {
                    this.newMarginTop = changeBookPageMarginsTool.newMarginTop;
                    this.timeStamp = changeBookPageMarginsTool.timeStamp;
                    return true;
                }
                if (this.oldMarginEnd != this.newMarginEnd && changeBookPageMarginsTool.oldMarginEnd != changeBookPageMarginsTool.newMarginEnd) {
                    this.newMarginEnd = changeBookPageMarginsTool.newMarginEnd;
                    this.timeStamp = changeBookPageMarginsTool.timeStamp;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.oldMargin != this.newMargin) {
            this.bookPage.setMargin(this.newMargin);
            return true;
        }
        if (this.oldMarginTop != this.newMarginTop) {
            this.bookPage.setMarginTop(this.newMarginTop);
            return true;
        }
        if (this.oldMarginBottom != this.newMarginBottom) {
            this.bookPage.setMarginBottom(this.newMarginBottom);
            return true;
        }
        if (this.oldMarginEnd != this.newMarginEnd) {
            this.bookPage.setMarginEnd(this.newMarginEnd);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.bookPage.setMargin(this.newMargin);
        this.bookPage.setMarginBottom(this.newMarginBottom);
        this.bookPage.setMarginEnd(this.newMarginEnd);
        this.bookPage.setMarginTop(this.newMarginTop);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookPage.setMargin(this.oldMargin);
        this.bookPage.setMarginBottom(this.oldMarginBottom);
        this.bookPage.setMarginEnd(this.oldMarginEnd);
        this.bookPage.setMarginTop(this.oldMarginTop);
        Controller.getInstance().updatePanel();
        return true;
    }
}

