/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookParagraph;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookParagraphDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class AddParagraphElementTool
extends Tool {
    private BookDataControl dataControl;
    private int type;
    private int selectedRow;
    private BookParagraph newBookParagraph;
    private BookParagraphDataControl newBookParagraphDataControl;

    public AddParagraphElementTool(BookDataControl bookDataControl, int n, int n2) {
        this.dataControl = bookDataControl;
        this.type = n;
        this.selectedRow = n2;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.newBookParagraph = null;
        if (this.type == 14) {
            this.newBookParagraph = new BookParagraph(3);
        } else if (this.type == 15) {
            this.newBookParagraph = new BookParagraph(2);
        } else if (this.type == 16) {
            this.newBookParagraph = new BookParagraph(0);
        } else if (this.type == 17) {
            this.newBookParagraph = new BookParagraph(1);
        }
        this.newBookParagraphDataControl = new BookParagraphDataControl(this.newBookParagraph);
        if (this.newBookParagraph != null) {
            if (this.selectedRow != -1 && this.selectedRow < this.dataControl.getBookParagraphsList().getBookParagraphs().size()) {
                this.dataControl.getBookParagraphsList().getBookParagraphsList().add(this.selectedRow + 1, this.newBookParagraph);
                this.dataControl.getBookParagraphsList().getBookParagraphs().add(this.selectedRow + 1, this.newBookParagraphDataControl);
            } else {
                this.dataControl.getBookParagraphsList().getBookParagraphsList().add(this.newBookParagraph);
                this.dataControl.getBookParagraphsList().getBookParagraphs().add(this.newBookParagraphDataControl);
            }
        }
        return this.newBookParagraph != null;
    }

    @Override
    public boolean redoTool() {
        if (this.newBookParagraph != null) {
            if (this.selectedRow != -1 && this.selectedRow < this.dataControl.getBookParagraphsList().getBookParagraphs().size()) {
                this.dataControl.getBookParagraphsList().getBookParagraphsList().add(this.selectedRow + 1, this.newBookParagraph);
                this.dataControl.getBookParagraphsList().getBookParagraphs().add(this.selectedRow + 1, this.newBookParagraphDataControl);
            } else {
                this.dataControl.getBookParagraphsList().getBookParagraphsList().add(this.newBookParagraph);
                this.dataControl.getBookParagraphsList().getBookParagraphs().add(this.newBookParagraphDataControl);
            }
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.getBookParagraphsList().getBookParagraphsList().remove(this.newBookParagraph);
        this.dataControl.getBookParagraphsList().getBookParagraphs().remove(this.newBookParagraphDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }
}

