/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.books;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class AddBookPageTool
extends Tool {
    private List<BookPage> bookPagesList;
    private BookPage newBookPage;
    private int selectedPage;

    public AddBookPageTool(List<BookPage> list, BookPage bookPage, int n) {
        this.bookPagesList = list;
        this.newBookPage = bookPage;
        this.selectedPage = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.selectedPage >= 0 && this.selectedPage < this.bookPagesList.size()) {
            this.bookPagesList.add(this.selectedPage + 1, this.newBookPage);
        } else {
            this.bookPagesList.add(this.newBookPage);
        }
        return true;
    }

    @Override
    public boolean redoTool() {
        if (this.selectedPage >= 0 && this.selectedPage < this.bookPagesList.size()) {
            this.bookPagesList.add(this.selectedPage + 1, this.newBookPage);
        } else {
            this.bookPagesList.add(this.newBookPage);
        }
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.bookPagesList.remove(this.newBookPage);
        Controller.getInstance().updatePanel();
        return true;
    }
}

