/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.assessment;

import es.eucm.eadventure.common.data.assessment.TimedAssessmentEffect;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteEffectTool
extends Tool {
    protected TimedAssessmentRule containsAS;
    protected TimedAssessmentEffect oldEffectBlock;
    protected int index;
    protected int mode;

    public DeleteEffectTool(TimedAssessmentRule timedAssessmentRule, int n) {
        this.containsAS = timedAssessmentRule;
        this.index = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.oldEffectBlock != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.index >= 0 && this.index < this.containsAS.getEffectsCount()) {
            this.oldEffectBlock = (TimedAssessmentEffect)this.containsAS.getEffects().remove(this.index);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.containsAS.getEffects().remove(this.index);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.containsAS.getEffects().add(this.index, this.oldEffectBlock);
        Controller.getInstance().updatePanel();
        return true;
    }
}

