/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.assessment;

import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeUsesEndCondition
extends Tool {
    private TimedAssessmentRule assessmentRule;
    private boolean newValue;
    private boolean oldValue;

    public ChangeUsesEndCondition(TimedAssessmentRule timedAssessmentRule, boolean bl) {
        this.assessmentRule = timedAssessmentRule;
        this.newValue = bl;
        this.oldValue = timedAssessmentRule.isUsesEndConditions();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.newValue == this.oldValue) {
            return false;
        }
        this.assessmentRule.setUsesEndConditions(this.newValue);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.assessmentRule.setUsesEndConditions(this.newValue);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.assessmentRule.setUsesEndConditions(this.oldValue);
        Controller.getInstance().updatePanel();
        return true;
    }
}

