/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.assessment;

import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeReportSettingsTool
extends Tool {
    public static final int SHOW_REPORT = 1;
    public static final int SEND = 2;
    public static final int EMAIL = 3;
    public static final int SMTP_SERVER = 4;
    public static final int SMTP_SSL = 5;
    public static final int SMTP_PORT = 6;
    public static final int SMTP_USER = 7;
    public static final int SMTP_PWD = 8;
    private AssessmentProfile profile;
    private int mode;
    private String oldValue;
    private String newValue;

    public ChangeReportSettingsTool(AssessmentProfile assessmentProfile, boolean bl, int n) {
        this.profile = assessmentProfile;
        this.newValue = Boolean.toString(bl);
        this.mode = n;
    }

    public ChangeReportSettingsTool(AssessmentProfile assessmentProfile, String string, int n) {
        this.profile = assessmentProfile;
        this.newValue = string;
        this.mode = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        boolean bl = true;
        ChangeReportSettingsTool changeReportSettingsTool = null;
        if (tool instanceof ChangeReportSettingsTool) {
            changeReportSettingsTool = (ChangeReportSettingsTool)tool;
            if (changeReportSettingsTool.profile != this.profile) {
                return false;
            }
        } else {
            return false;
        }
        if (this.mode != changeReportSettingsTool.mode) {
            return false;
        }
        switch (this.mode) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                this.newValue = changeReportSettingsTool.newValue;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean doTool() {
        boolean bl = true;
        switch (this.mode) {
            case 1: {
                this.oldValue = Boolean.toString(this.profile.isShowReportAtEnd());
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setShowReportAtEnd(Boolean.parseBoolean(this.newValue));
                break;
            }
            case 2: {
                this.oldValue = Boolean.toString(this.profile.isSendByEmail());
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setSendByEmail(Boolean.parseBoolean(this.newValue));
                break;
            }
            case 3: {
                this.oldValue = this.profile.getEmail();
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setEmail(this.newValue);
                break;
            }
            case 4: {
                this.oldValue = this.profile.getSmtpServer();
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setSmtpServer(this.newValue);
                break;
            }
            case 5: {
                this.oldValue = Boolean.toString(this.profile.isSmtpSSL());
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setSmtpSSL(Boolean.parseBoolean(this.newValue));
                break;
            }
            case 6: {
                this.oldValue = this.profile.getSmtpPort();
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setSmtpPort(this.newValue);
                break;
            }
            case 7: {
                this.oldValue = this.profile.getSmtpUser();
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setSmtpUser(this.newValue);
                break;
            }
            case 8: {
                this.oldValue = this.profile.getSmtpPwd();
                if (this.oldValue == null && this.newValue == null || this.oldValue.equals(this.newValue)) {
                    bl = false;
                    break;
                }
                this.profile.setSmtpPwd(this.newValue);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean redoTool() {
        boolean bl = true;
        switch (this.mode) {
            case 1: {
                this.profile.setShowReportAtEnd(Boolean.parseBoolean(this.newValue));
                break;
            }
            case 2: {
                this.profile.setSendByEmail(Boolean.parseBoolean(this.newValue));
                break;
            }
            case 3: {
                this.profile.setEmail(this.newValue);
                break;
            }
            case 4: {
                this.profile.setSmtpServer(this.newValue);
                break;
            }
            case 5: {
                this.profile.setSmtpSSL(Boolean.parseBoolean(this.newValue));
                break;
            }
            case 6: {
                this.profile.setSmtpPort(this.newValue);
                break;
            }
            case 7: {
                this.profile.setSmtpUser(this.newValue);
                break;
            }
            case 8: {
                this.profile.setSmtpPwd(this.newValue);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }

    @Override
    public boolean undoTool() {
        boolean bl = true;
        switch (this.mode) {
            case 1: {
                this.profile.setShowReportAtEnd(Boolean.parseBoolean(this.oldValue));
                if (!this.profile.isSendByEmail()) break;
                this.profile.setSendByEmail(false);
                break;
            }
            case 2: {
                this.profile.setSendByEmail(Boolean.parseBoolean(this.oldValue));
                break;
            }
            case 3: {
                this.profile.setEmail(this.oldValue);
                break;
            }
            case 4: {
                this.profile.setSmtpServer(this.oldValue);
                break;
            }
            case 5: {
                this.profile.setSmtpSSL(Boolean.parseBoolean(this.oldValue));
                break;
            }
            case 6: {
                this.profile.setSmtpPort(this.oldValue);
                break;
            }
            case 7: {
                this.profile.setSmtpUser(this.oldValue);
                break;
            }
            case 8: {
                this.profile.setSmtpPwd(this.oldValue);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            Controller.getInstance().updatePanel();
        }
        return bl;
    }
}

