/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.assessment;

import es.eucm.eadventure.common.data.assessment.TimedAssessmentEffect;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeMinTimeValueTool
extends Tool {
    private TimedAssessmentEffect effect;
    private int newMinTime;
    private int oldMinTime;
    private int newMaxTime;
    private int oldMaxTime;

    public ChangeMinTimeValueTool(TimedAssessmentEffect timedAssessmentEffect, int n) {
        this.effect = timedAssessmentEffect;
        this.newMinTime = n;
        this.oldMinTime = this.effect.getMinTime();
        this.oldMaxTime = this.effect.getMaxTime();
        this.newMaxTime = this.oldMaxTime > this.newMinTime ? this.oldMaxTime : this.newMinTime + 1;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeMinTimeValueTool) {
            ChangeMinTimeValueTool changeMinTimeValueTool = (ChangeMinTimeValueTool)tool;
            if (changeMinTimeValueTool.effect == this.effect) {
                this.newMinTime = changeMinTimeValueTool.newMinTime;
                this.newMaxTime = changeMinTimeValueTool.newMaxTime;
                this.timeStamp = changeMinTimeValueTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        this.effect.setMaxTime(Integer.valueOf(this.newMaxTime));
        this.effect.setMinTime(Integer.valueOf(this.newMinTime));
        return true;
    }

    @Override
    public boolean redoTool() {
        this.effect.setMaxTime(Integer.valueOf(this.newMaxTime));
        this.effect.setMinTime(Integer.valueOf(this.newMinTime));
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.effect.setMaxTime(Integer.valueOf(this.oldMaxTime));
        this.effect.setMinTime(Integer.valueOf(this.oldMinTime));
        Controller.getInstance().updatePanel();
        return true;
    }
}

