/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.assessment;

import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;
import java.util.List;

public class ChangeAssessmentPropertyTool
extends Tool {
    public static final int SET_ID = 2;
    public static final int SET_VALUE = 3;
    public static final int SET_VARNAME = 4;
    protected String oldValue;
    protected String newValue;
    protected List<AssessmentProperty> list;
    protected int mode;
    protected int index;

    public ChangeAssessmentPropertyTool(List<AssessmentProperty> list, String string, int n, int n2) {
        this.mode = n2;
        this.list = list;
        this.index = n;
        this.newValue = string;
        if (n2 == 2) {
            this.oldValue = this.list.get(n).getId();
        } else if (n2 == 3) {
            this.oldValue = this.list.get(n).getValue();
        } else if (n2 == 4) {
            this.oldValue = this.list.get(n).getVarName();
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.mode == 2 || this.mode == 3 || this.mode == 4;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.mode == 2) {
            this.list.get(this.index).setId(this.newValue);
            return true;
        }
        if (this.mode == 3) {
            this.list.get(this.index).setValue(this.newValue);
            return true;
        }
        if (this.mode == 4) {
            this.list.get(this.index).setVarName(this.newValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        boolean bl = this.doTool();
        Controller.getInstance().updatePanel();
        return bl;
    }

    @Override
    public boolean undoTool() {
        if (this.mode == 2) {
            this.list.get(this.index).setId(this.oldValue);
            Controller.getInstance().updatePanel();
            return true;
        }
        if (this.mode == 3) {
            this.list.get(this.index).setValue(this.oldValue);
            Controller.getInstance().updatePanel();
            return true;
        }
        if (this.mode == 4) {
            this.list.get(this.index).setVarName(this.oldValue);
            Controller.getInstance().updatePanel();
            return true;
        }
        return false;
    }
}

