/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.assessment;

import es.eucm.eadventure.common.data.assessment.TimedAssessmentEffect;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class AddEffectTool
extends Tool {
    protected TimedAssessmentRule containsAS;
    protected TimedAssessmentEffect oldEffectBlock;
    protected int index;
    protected int mode;

    public AddEffectTool(TimedAssessmentRule timedAssessmentRule, int n) {
        this.containsAS = timedAssessmentRule;
        this.index = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.oldEffectBlock != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.containsAS.addEffect();
        this.oldEffectBlock = this.containsAS.getLastEffect();
        return true;
    }

    @Override
    public boolean redoTool() {
        this.containsAS.getEffects().add(this.oldEffectBlock);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.containsAS.getEffects().remove(this.oldEffectBlock);
        Controller.getInstance().updatePanel();
        return true;
    }
}

