/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.animation.AnimationDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class MoveFrameRightTool
extends Tool {
    private AnimationDataControl animationDataControl;
    private FrameDataControl frameDataControl;
    private Animation animation;
    private Frame frame;
    private int index;

    public MoveFrameRightTool(AnimationDataControl animationDataControl, FrameDataControl frameDataControl) {
        this.animationDataControl = animationDataControl;
        this.frameDataControl = frameDataControl;
        this.animation = (Animation)animationDataControl.getContent();
        this.frame = (Frame)frameDataControl.getContent();
        this.index = animationDataControl.getFrameDataControls().indexOf(frameDataControl);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.index == this.animationDataControl.getFrameCount() - 1) {
            return false;
        }
        this.animation.getFrames().remove(this.frame);
        this.animationDataControl.getFrameDataControls().remove(this.frameDataControl);
        this.animation.getFrames().add(this.index + 1, this.frame);
        this.animationDataControl.getFrameDataControls().add(this.index + 1, this.frameDataControl);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.animation.getFrames().remove(this.frame);
        this.animationDataControl.getFrameDataControls().remove(this.frameDataControl);
        this.animation.getFrames().add(this.index + 1, this.frame);
        this.animationDataControl.getFrameDataControls().add(this.index + 1, this.frameDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.animation.getFrames().remove(this.frame);
        this.animationDataControl.getFrameDataControls().remove(this.frameDataControl);
        this.animation.getFrames().add(this.index, this.frame);
        this.animationDataControl.getFrameDataControls().add(this.index, this.frameDataControl);
        Controller.getInstance().updatePanel();
        return true;
    }
}

