/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.Transition;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.animation.AnimationDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.control.controllers.animation.TransitionDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteFrameTool
extends Tool {
    private FrameDataControl frameDataControl;
    private AnimationDataControl animationDataControl;
    private Transition transition;
    private TransitionDataControl transitionDataControl;
    private Frame frame;
    private Animation animation;
    private int index;

    public DeleteFrameTool(AnimationDataControl animationDataControl, FrameDataControl frameDataControl) {
        this.frameDataControl = frameDataControl;
        this.animationDataControl = animationDataControl;
        this.animation = (Animation)animationDataControl.getContent();
        this.frame = (Frame)frameDataControl.getContent();
        this.index = this.animation.getFrames().indexOf(frameDataControl.getContent());
        this.transitionDataControl = this.animationDataControl.getTransitionDataControls().get(this.index + 1);
        this.transition = (Transition)this.transitionDataControl.getContent();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.animationDataControl.getFrameCount() == 1) {
            return false;
        }
        this.animationDataControl.getFrameDataControls().remove(this.frameDataControl);
        this.animationDataControl.getTransitionDataControls().remove(this.transitionDataControl);
        this.animation.getFrames().remove(this.frame);
        this.animation.getTransitions().remove(this.transition);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.animationDataControl.getFrameDataControls().remove(this.frameDataControl);
        this.animationDataControl.getTransitionDataControls().remove(this.transitionDataControl);
        this.animation.getFrames().remove(this.frame);
        this.animation.getTransitions().remove(this.transition);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.animationDataControl.getFrameDataControls().add(this.index, this.frameDataControl);
        this.animationDataControl.getTransitionDataControls().add(this.index + 1, this.transitionDataControl);
        this.animation.getFrames().add(this.index, this.frame);
        this.animation.getTransitions().add(this.index + 1, this.transition);
        Controller.getInstance().updatePanel();
        return true;
    }
}

