/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeUseTransitionsTool
extends Tool {
    private Animation animation;
    private boolean useTransitions;
    private boolean oldUseTransitions;

    public ChangeUseTransitionsTool(Animation animation, boolean bl) {
        this.animation = animation;
        this.useTransitions = bl;
        this.oldUseTransitions = animation.isUseTransitions();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.useTransitions == this.oldUseTransitions) {
            return false;
        }
        this.animation.setUseTransitions(this.useTransitions);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.animation.setUseTransitions(this.useTransitions);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.animation.setUseTransitions(this.oldUseTransitions);
        Controller.getInstance().updatePanel();
        return true;
    }
}

