/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.animation;

import es.eucm.eadventure.common.data.animation.Transition;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.tools.Tool;

public class ChangeTransitionTypeTool
extends Tool {
    private Transition transition;
    private int newType;
    private int oldType;

    public ChangeTransitionTypeTool(Transition transition, int n) {
        this.transition = transition;
        this.newType = n;
        this.oldType = transition.getType();
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        if (tool instanceof ChangeTransitionTypeTool) {
            ChangeTransitionTypeTool changeTransitionTypeTool = (ChangeTransitionTypeTool)tool;
            if (changeTransitionTypeTool.transition == this.transition) {
                this.newType = changeTransitionTypeTool.newType;
                this.timeStamp = changeTransitionTypeTool.timeStamp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doTool() {
        this.transition.setType(this.newType);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.transition.setType(this.newType);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.transition.setType(this.oldType);
        Controller.getInstance().updatePanel();
        return true;
    }
}

